/*
** #################################################################################
**
**     Filename  : DEMOQE128_Quick_Start.c
** 
**     Version   : 0.2
**
**     Compiler  : Freescale CodeWarrior C Compiler
**
**     Date      : May 21, 2007
**
**##################################################################################     
**
**     Copyright (C) 2007, P&E Microcomputer Systems, Inc.
**
**     Code in the Quick Start C file may be used freely as long as this copyright
**     notice and website information are included.
**
**     Visit us at      http://www.pemicro.com
**
**     for programming, development, test, and production tools.
**
** #################################################################################
*/

#include <hidef.h>                        /* for EnableInterrupts macro */
#include "derivative.h"                   /* include peripheral declarations */
#include "DEMOQE128_Quick_Start.h"        /* include variable declarations */

void InitSystems() {
  
  SOPT1  = 0x23;                          // Disable COP,RSTO, enable STOP,BKGD,RESET
  SOPT2  = 0x00;                          // SPI1 on PTB2/3/4/5, IIC1 on PTA2/3
  SPMSC1 = 0x00;                          // Disable LVD
  SPMSC2 = 0x00;                          // Disable power-down modes
  SPMSC3 = 0x00;                          // Disable LVWIE, low trip points
  SCGC1  = 0xFF;                          // Enable bus clock to peripherals
  SCGC2  = 0xFF;                          // Enable bus clock to peripherals
} // end InitSystems

void EnablePullups() {
  
  PTAPE = 0xFF;                           // Enable PORT A Internal Pullups
  PTBPE = 0xFF;                           // Enable PORT B Internal Pullups
  PTCPE = 0xFF;                           // Enable PORT C Internal Pullups
  PTDPE = 0xFF;                           // Enable PORT D Internal Pullups
  PTEPE = 0xFF;                           // Enable PORT E Internal Pullups
  PTFPE = 0xFF;                           // Enable PORT F Internal Pullups
  PTGPE = 0x0F;                           // Enable PTG0/1/2/3 Internal Pullups
  PTHPE = 0xC3;                           // Enable PTH0/1/6/7 Internal Pullups
} //end EnablePullups

void InitKBI() {
  
  /*KBI1 Init*/
  KBI1SC_KBIE   = 0;                      // Mask KBI1 interrupts
                                           
                                              
  KBI1ES_KBEDG3 = 0;                      // KBI1P3 internal pull-up, falling edge/low level
  KBI1ES_KBEDG2 = 0;                      // KBI1P2 internal pull-up, falling edge/low level

                                           
  KBI1PE_KBIPE3 = 1;                      // Enable KBI1P3 interrupts  
  KBI1PE_KBIPE2 = 1;                      // Enable KBI1P2 interrupts  
                                           
  KBI1SC_KBIMOD = 0;                      // Detect edges only
                                             
  KBI1SC_KBACK  = 1;                      // Clear possible false interrupts

  
  KBI1SC_KBIE   = 1;                      // Enable KBI1 interrupts
  
  /*KBI2 Init*/
  KBI2SC_KBIE   = 0;                      // Mask KBI2 interrupts
                                           
                                              
  KBI2ES_KBEDG3 = 0;                      // KBI2P3 internal pull-up, falling edge/low level
  KBI2ES_KBEDG2 = 0;                      // KBI2P2 internal pull-up, falling edge/low level

                                           
  KBI2PE_KBIPE3 = 1;                      // Enable KBI2P3 interrupts  
  KBI2PE_KBIPE2 = 1;                      // Enable KBI2P2 interrupts  
                                           
  KBI2SC_KBIMOD = 0;                      // Detect edges only
                                             
  KBI2SC_KBACK  = 1;                      // Clear possible false interrupts

  
  KBI2SC_KBIE   = 1;                      // Enable KBI2 interrupts
} //end InitKBI

void InitADC(void) {
  
  byte done = 0x00;
  ADCSC1 = 0x1F;                          /* Disable interrupts 
                                             Disable continuous conversions
                                             Disable ADC by setting all ADCH bits */
  ADCSC2 = 0x40;                          /* Select H/W trigger
                                             Disable compare function */
  ADCCFG = 0x03; 	                        /* ADIV=input clock/8
                                             ADLSMP=long sample time
                                             MODE=8-bit conversion
                                             ADICLK=async clock */
  APCTL1 = 0x01;                          // Enable ADP0 as ADC input
} //end InitADC

void SetADC(byte adc_channel, byte aien_value) {

  ADCSC1_AIEN = aien_value&0x01;
  ADCSC1_ADCH = adc_channel;
} //end SetADC

// Initialize the TPM1 for PWM outputs (Channel 1 for Buzzer)
void TPM1Cx_PWM(byte CHAN, byte DUTY_CYCLE, word MOD, byte CLK_PS) {

    int val;
    
    if (MOD==0) {
      
       TPM1SC=0x00;                       // disable PWM.
       return; 
    }
    if ((TPM1MODH==(MOD>>8)) && (TPM1MODL==(MOD-1))) {
      
    } else {
      
       TPM1MODH = (byte) (MOD>>8);			  // set period 
       TPM1MODL = (byte) (MOD-1);
    }
    
    switch (CHAN) {
    
      case 0: 
           TPM1C0SC = 0x24;               // Center-aligned low-true pulses
           if (MOD>100){
              val = DUTY_CYCLE*(MOD/100);
           }
           else {
              val = DUTY_CYCLE*MOD/100;
           }
           
           TPM1C0VH = (byte) (val>>8);    // set duty cycle for Channel 0
           TPM1C0VL = (byte) (val);
      break;
        
      case 1:
           TPM1C1SC = 0x24;               // Center-aligned low-true pulses
           if (MOD>100){
              val = DUTY_CYCLE*(MOD/100);
           }
           else {
              val = DUTY_CYCLE*MOD/100;
           }
           
           TPM1C1VH = (byte) (val>>8);    // set duty cycle for Channel 1
           TPM1C1VL = (byte) (val);
      break;
        
      case 2:
           TPM1C2SC = 0x24;               // Center-aligned low-true pulses
           if (MOD>100){
              val = DUTY_CYCLE*(MOD/100);
           }
           else {
              val = DUTY_CYCLE*MOD/100;
           }
           
           TPM1C2VH = (byte) (val>>8);    // set duty cycle for Channel 2
           TPM1C2VL = (byte) (val);
      break;
        
      default:
      break;      
    }
    
    TPM1SC   = (byte) (0x08|(CLK_PS&0x07));        // individual aligned, bus frequency/Prescale, start timer
} //end TPM1Cx_PWM

// Initialize the TPM3 Channels 0-5 for PWM outputs (LEDs)
void TPM3Cx_PWM(byte CHAN, byte DUTY_CYCLE, word MOD, byte CLK_PS) {

    int val;
    
    if (MOD==0) {
      
       TPM3SC=0x00;                       // disable PWM.
       return; 
    }
    if ((TPM3MODH==(MOD>>8)) && (TPM3MODL==(MOD-1))) {
      
    } else {
      
       TPM3MODH = (byte) (MOD>>8);		    // set period 
       TPM3MODL = (byte) (MOD-1);
    }
    
    
    switch (CHAN) {
    
      case 0: 
           TPM3C0SC = 0x24;               // Center-aligned low-true pulses
           
           if (MOD>100){
              val = DUTY_CYCLE*(MOD/100);
           }
           else {
              val = DUTY_CYCLE*MOD/100;
           }
           
           TPM3C0VH = (byte) (val>>8);    // set duty cycle for Channel 0
           TPM3C0VL = (byte) (val);
      break;
        
      case 1:
           TPM3C1SC = 0x24;               // Center-aligned low-true pulses
           if (MOD>100){
              val = DUTY_CYCLE*(MOD/100);
           }
           else {
              val = DUTY_CYCLE*MOD/100;
           }
           
           TPM3C1VH = (byte) (val>>8);    // set duty cycle for Channel 1
           TPM3C1VL = (byte) (val);
      break;
        
      case 2:
           TPM3C2SC = 0x24;               // Center-aligned low-true pulses
           if (MOD>100){
              val = DUTY_CYCLE*(MOD/100);
           }
           else {
              val = DUTY_CYCLE*MOD/100;
           }
           
           TPM3C2VH = (byte) (val>>8);    // set duty cycle for Channel 2
           TPM3C2VL = (byte) (val);
      break;
        
      case 3:
           TPM3C3SC = 0x24;               // Center-aligned low-true pulses
           if (MOD>100){
              val = DUTY_CYCLE*(MOD/100);
           }
           else {
              val = DUTY_CYCLE*MOD/100;
           }
           
           TPM3C3VH = (byte) (val>>8);    // set duty cycle for Channel 3
           TPM3C3VL = (byte) (val);
      break;
        
      case 4:
           TPM3C4SC = 0x24;               // Center-aligned low-true pulses
           if (MOD>100){
              val = DUTY_CYCLE*(MOD/100);
           }
           else {
              val = DUTY_CYCLE*MOD/100;
           }
           
           TPM3C4VH = (byte) (val>>8);    // set duty cycle for Channel 4
           TPM3C4VL = (byte) (val);
      break;
        
      case 5:
           TPM3C5SC = 0x24;               // Center-aligned low-true pulses
           if (MOD>100){
              val = DUTY_CYCLE*(MOD/100);
           }
           else {
              val = DUTY_CYCLE*MOD/100;
           }
           
           TPM3C5VH = (byte) (val>>8);    // set duty cycle for Channel 5
           TPM3C5VL = (byte) (val);
      break;
        
      default:
      break;      
    }
    
    TPM3SC   = (byte) (0x28|(CLK_PS&0x07));        // All center-aligned, bus frequency/Prescale, start timer
} //end TPM3Cx_PWM

/************************
   Main Program Loop
************************/
void main(void) {

  byte tempA, tempD;
  
  some_key_pressed = no;
  key_press_debounced = no;
  
  InitSystems();
  EnablePullups();
  InitADC();
  InitKBI(); 

  RTCMOD = 0x01;                          // set ADC conversion period
  RTCSC  = 0x0B;                          // 10ms period, no interrupt

  SetADC(0x00,0x01);                      // ADC0, enable interrupt

  EnableInterrupts;
  
  // Turn ON PTE6/7 LEDs 

  // PTED  &= 0x3F;
  // PTEDD |= 0xC0;

  // or

  PTED_PTED6   = 0;
  PTEDD_PTEDD6 = 1;                       // Turn ON PTE6 LED

  PTED_PTED7   = 0;
  PTEDD_PTEDD7 = 1;                       // Turn ON PTE7 LED

  for (;;) {
      if (some_key_pressed&&key_press_debounced) {
         
                                          
         tempA = PTAD;                    // get the key pressed
         tempD = PTDD;                    // get the key pressed
         
         if ((tempA&0x04)==0x00) {        // PTA2 key pressed

            TPM3Cx_PWM(1,25,666,0x06);   // PTC1 LED 25% duty cycle ON.
            TPM1Cx_PWM(1,50,2560,0x00);   // Buzzer sound 1
            while ((PTAD&0x04)==0x00) {
                  ;                       // Wait till key is released
            }
            TPM3Cx_PWM(1,0,666,0x06);    // PTC1 LED OFF
         }                                
         if ((tempA&0x08)==0x00) {        // PTA3 key pressed

            TPM3Cx_PWM(2,50,666,0x06);   // PTC2 LED 50% duty cycle ON.
            TPM1Cx_PWM(1,50,2304,0x00);   // Buzzer sound 2
            while ((PTAD&0x08)==0x00) {
                  ;                       // Wait till key is released
            }
            TPM3Cx_PWM(2,0,666,0x06);    // PTC2 LED OFF
         }                                
         if ((tempD&0x04)==0x00) {        // PTD2 key pressed

            TPM3Cx_PWM(3,75,666,0x06);   // PTC3 LED 75% duty cycle ON.
            TPM1Cx_PWM(1,50,2048,0x00);   // Buzzer sound 3
            while ((PTDD&0x04)==0x00) {
                  ;                       // Wait till key is released
            }
            TPM3Cx_PWM(3,0,666,0x06);    // PTC3 LED OFF
         }                                
         if ((tempD&0x08)==0x00) {        // PTD3 key pressed

            TPM3Cx_PWM(4,90,666,0x06);   // PTC4 LED 100% duty cycle ON.
            TPM1Cx_PWM(1,50,1792,0x00);   // Buzzer sound 4
            while ((PTDD&0x08)==0x00) {
                  ;                       // Wait till key is released
            }
            TPM3Cx_PWM(4,0,666,0x06);    // PTC4 LED OFF
         }                                
         
         key_press_debounced = no;

         RTCSC_RTIF   = 1;                // Clear RTIF flag
         RTCMOD = 0x01;                   // Set debounce period 10ms
         RTCSC  = 0x1B;                   // Enable RTIE
         
         while (!key_press_debounced) {
               ;                          // debounce key
         }

         TPM1Cx_PWM(1,50,0,0x04);         // Buzzer OFF

         some_key_pressed = no;
         key_press_debounced = no;

         KBI1SC_KBIE = 1;                 // enable KBI1 interrupts
         KBI2SC_KBIE = 1;                 // enable KBI2 interrupts
      }                     
  }
} //end main

/*********************************************************************
**  Interrupt Service Routines
*********************************************************************/
interrupt VectorNumber_Vadc void   ADC_ISR(void) {

  word adc_val;
    
  adc_val  = (word) (ADCRH<<8);                     // Read ADC value, clear flag
  adc_val |= (word) (ADCRL);                       // 8-bit, ignore high byte
  
  TPM3Cx_PWM(0,(byte)(((0xFFFF-adc_val)&0x00FF)>>1),666,0x06); 
  TPM3Cx_PWM(5,(byte)((adc_val&0x00FF)>>1),666,0x06);
}

interrupt VectorNumber_Vkeyboard void   KBIx_ISR(void) {

  some_key_pressed  = yes;
  key_press_debounced = no;
  
  KBI1SC_KBIE  = 0;                       // Disable KBI1 interrupts
  KBI2SC_KBIE  = 0;                       // Disable KBI2 interrupts
  
  KBI1SC_KBACK = 1;                       // Clear KBACK
  KBI2SC_KBACK = 1;                       // Clear KBACK

  RTCSC_RTIF   = 1;                       // Clear RTIF flag
  RTCMOD = 0x01;                          // Set debounce period 10ms
  RTCSC  = 0x1B;                          // Enable RTIE
}

interrupt VectorNumber_Vrtc void   RTC_ISR(void) {
  if (some_key_pressed) {
     RTCMOD = 0x01;                       // set period 10ms
     RTCSC  = 0x0B;                       // Disable RTIE
     key_press_debounced = yes;
  }
  RTCSC_RTIF = 1;                         // clear flag
}
